unit DataModule;

interface

uses
  SysUtils, Classes, DB, IBDatabase, Dialogs, IBCustomDataSet, IBQuery,
  IBTable, IBStoredProc;

type
  TDM = class(TDataModule)
    IBDatabase: TIBDatabase;
    IBTransaction: TIBTransaction;
    QueryOsoby: TIBQuery;
    dsOsoby: TDataSource;
    QueryCount: TIBQuery;
    IBQueryEDIT: TIBQuery;
    IBQueryINSERT: TIBQuery;
    IBQueryDELETE: TIBQuery;
    IBStoredProc1: TIBStoredProc;
    QueryOsobyIDOSOBY: TIntegerField;
    QueryOsobyNAZWISKO: TIBStringField;
    QueryOsobyIMIE: TIBStringField;
    QueryOsobyDATAUR: TDateField;
    QueryOsobyMCOWOSC: TIBStringField;
    QueryOsobyULICAINR: TIBStringField;
    QueryOsobyKODP: TIBStringField;
    QueryOsobyMIASTO: TIBStringField;
    QueryOsobyPESEL: TIBStringField;
    procedure DataModuleCreate(Sender: TObject);
    procedure DataModuleDestroy(Sender: TObject);
    procedure QueryOsobyDATAURGetText(Sender: TField; var Text: String;
      DisplayText: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DM: TDM;

implementation
{$R *.dfm}

Uses
   DateUtils, 
   Variants;

procedure TDM.DataModuleCreate(Sender: TObject);
begin
   if not IBDataBase.Connected then
   begin
      IBDatabase.Connected := True;
      // lub: IBDatabase.Open();
   end;
end;

procedure TDM.DataModuleDestroy(Sender: TObject);
begin
   if IBDataBase.Connected then
   begin
      IBDatabase.Connected := False;
      // lub: IBDatabase.Close();
   end;
end;

procedure TDM.QueryOsobyDATAURGetText(Sender: TField;
                                      var Text: String;
                                      DisplayText: Boolean);
var
   Pole    : Variant;
// DataUr  : TDateTime;
   DataUr  : Variant;
   Dzisiaj : TDateTime;
   Roznica : Integer;

begin
(*
   Pole := Sender.Value;

   if VarIsNull(Pole) then begin
      Text := 'Do ustalania';
   end
   else begin
      DataUr  := Pole;
      Dzisiaj := Now();
      Roznica := YearsBetween(Dzisiaj, DataUr);
      Text    := 'wiek ' + IntToStr(Roznica) + ' lat, data ur. ' + DateToStr(DataUr);
   end;
*)

   // lub druga wersja z polem DataUr : Variant

   DataUr := Sender.Value;

   if VarIsNull(DataUr) then
   begin
      Text := 'Do ustalania';
   end
   else begin
      Dzisiaj := Now();
      Roznica := YearsBetween(Dzisiaj, DataUr);
      Text    := 'wiek ' + IntToStr(Roznica) + ' lat, data ur. ' + DateToStr(DataUr);
   end;
end;

end.

